<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace PrestaShop\Module\PsAccounts\Vendor\Symfony\Component\Cache\Simple;

use PrestaShop\Module\PsAccounts\Vendor\Psr\SimpleCache\CacheInterface;
/**
 * @author Nicolas Grekas <p@tchwork.com>
 */
class NullCache implements CacheInterface
{
    /**
     * {@inheritdoc}
     */
    public function get($key, $default = null)
    {
        return $default;
    }
    /**
     * {@inheritdoc}
     */
    public function getMultiple($keys, $default = null)
    {
        foreach ($keys as $key) {
            (yield $key => $default);
        }
    }
    /**
     * {@inheritdoc}
     */
    public function has($key)
    {
        return \false;
    }
    /**
     * {@inheritdoc}
     */
    public function clear()
    {
        return \true;
    }
    /**
     * {@inheritdoc}
     */
    public function delete($key)
    {
        return \true;
    }
    /**
     * {@inheritdoc}
     */
    public function deleteMultiple($keys)
    {
        return \true;
    }
    /**
     * {@inheritdoc}
     */
    public function set($key, $value, $ttl = null)
    {
        return \false;
    }
    /**
     * {@inheritdoc}
     */
    public function setMultiple($values, $ttl = null)
    {
        return \false;
    }
}
